# build this image from top level of the release package
FROM docker.io/debian:trixie-slim

# deploy deb packages
COPY ./dist/trixie/lib3djuump-infinite-cli_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/
COPY ./dist/trixie/lib3djuump-infinite-proxy_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/
COPY ./dist/trixie/3djuump-infinite-migration-3.1-3.2_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/
COPY ./dist/trixie/3djuump-infinite-migration-3.2-3.3_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/
COPY ./dist/trixie/3djuump-infinite-migration-3.3-4.0_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/
COPY ./dist/trixie/3djuump-infinite-migration-4.0-4.1_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/
COPY ./dist/trixie/3djuump-infinite-cli_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/
COPY ./dist/trixie/3djuump-infinite-proxy_4.1.24.7186-9a016eff14406b1e_amd64_trixie*.deb /tmp/

# set package install non interactive
ARG DEBIAN_FRONTEND=noninteractive

# update apt
RUN apt update
RUN apt --assume-yes upgrade

# configure locale
RUN apt --assume-yes install locales
RUN echo "en_US.UTF-8 UTF-8" >> /etc/locale.gen
RUN locale-gen
ENV LANG=en_US.UTF-8
ENV LANGUAGE=en_US:en
ENV LC_ALL=en_US.UTF-8
RUN export

# need wget for health check and adduser
RUN apt --assume-yes install wget adduser

# pre-install dependencies
COPY ["./install form/docker/install_deb_dependencies.sh","/tmp/install_deb_dependencies.sh"]
RUN /bin/bash /tmp/install_deb_dependencies.sh

# create juumpinfinite user
RUN adduser juumpinfinite
RUN passwd -d juumpinfinite

# accept eula
RUN echo "lib3djuump-infinite-cli lib3djuump-infinite-cli/eula string yes" > /tmp/debconf.conf
RUN debconf-set-selections /tmp/debconf.conf

# install deb packages
RUN dpkg --force-all -i /tmp/*.deb

# remove tmp files deb packages
RUN rm -rf /tmp/*
RUN apt clean

EXPOSE 80

STOPSIGNAL SIGINT

COPY ["./install form/docker/run_proxy.sh","/run_proxy.sh"]
RUN ["chmod","+rx","/run_proxy.sh"]

USER juumpinfinite

ENTRYPOINT ["/run_proxy.sh"]
#ENTRYPOINT ["sleep", "500000000000000000000000000000000000000"]
